;; The first three lines of this file were inserted by DrRacket. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(lib "htdp-intermediate-lambda-reader.ss" "lang")((modname fun-quiz) (read-case-sensitive #t) (teachpacks ()) (htdp-settings #(#t constructor repeating-decimal #f #t none #f () #f)))
(require 2htdp/batch-io)
(require 2htdp/image)
(require 2htdp/universe)

;; a fun quiz
;; made by Auren Amster, May 2023 <biz@aurenamster.com>

; A QuizPlayer is a (make-qp Quiz QuizResult)
(define-struct quiz-player [quiz result])
; and represents the part of the quiz that still has to be taken
; and the results of the quiz taken so far

; A Quiz is a [List-of Question]

; A Question is a (make-question String [List-of String] Nat)
(define-struct question [question answers correct])
; and represents the question content,
; the multiple choice options,
; and which option is correct (1-indexed)
; note that correct should always be less than the length of answers

(define america (make-question "When was the United States Constitution signed into law?" '("1764" "1776" "1783" "1787") 4))
(define prog-lang (make-question "What is the best programming language?" '("C" "Racket" "C++" "Java" "Python" "Lisp") 2))
(define prog-lang/trick (make-question "What is the second-best programming language?"
                                       '("HTTP" "SFTP" "node.js" "Arduino C" "these are not programming languages")
                                       5))
(define graphite (make-question "What is the chemical composition of graphite?" '("H₂O" "NaCl"  "carbon allotrope" "3(O₂N₂CH₂)") 3))
(define lincoln (make-question "What was the first name of the man\n who assasinated President Abraham Lincoln?"
                               '("John" "Henry" "William" "Arthur" "Theodore" "Thomas") 1))
(define hello (make-question "In what language does mba'eichapa mean \"hello\"?" '("Danish" "Guarani" "Hmong" "Igbo" "Lingala") 2))

(define the-quiz (list prog-lang graphite hello america prog-lang/trick lincoln))

; A QuizResult is a [List-of Result]

; A Result is a (make-result Question Nat)
(define-struct result [question answer])
; and represents the original question and the answer given
(define lincoln-right (make-result lincoln 1))
(define trick-wrong (make-result prog-lang/trick 2))

; quiz-program : Quiz String -> String
; Complete the given quiz and record the answers in the given file
(define (quiz-program quiz file)
  (write-file file (quiz-results->output (run-quiz quiz file))))

; quiz-results->output : QuizResult -> String
; Convert the quiz results to the string to be output
(define (quiz-results->output results)
  (local [; add-result : Result String -> String
          ; Append a result followed by a new line to str
          (define (add-result result str)
            (string-append str "\n" (result->str result)))
          
          ; result->str : Result -> String
          ; Convert a result to a string
          (define (result->str result)
            (local [(define question (result-question result))]
              (string-append "Question: \"" (question-question question)
                             "\" Correct answer: " (list-ref (question-answers question) (sub1 (question-correct question)))
                             " (" (number->string (question-correct question)) ") "
                             "Answer given: " (if (and (positive? (result-answer result)) (<= (result-answer result) (length (question-answers question))))
                                                  (list-ref (question-answers question) (sub1 (result-answer result)))
                                                  "<undefined>")
                             " (" (number->string (result-answer result)) ") [" (if (= (result-answer result) (question-correct question)) "RIGHT" "WRONG") "]")))]
    (foldr add-result "" results)))
(check-expect (quiz-results->output (list lincoln-right))
              "\nQuestion: \"What was the first name of the man\n who assasinated President Abraham Lincoln?\" Correct answer: John (1) Answer given: John (1) [RIGHT]")
(check-expect (quiz-results->output (list trick-wrong))
              "\nQuestion: \"What is the second-best programming language?\" Correct answer: these are not programming languages (5) Answer given: SFTP (2) [WRONG]")
(check-expect (quiz-results->output (list (make-result lincoln 69)))
              "\nQuestion: \"What was the first name of the man\n who assasinated President Abraham Lincoln?\" Correct answer: John (1) Answer given: <undefined> (69) [WRONG]")



; run-quiz : Quiz, String -> QuizResult
; Run the quiz, record results
(define (run-quiz quiz file)
  (quiz-player-result
   (big-bang (make-quiz-player quiz '())
     [to-draw draw-quiz]
     [on-key enter-guess]
     [stop-when (compose empty? quiz-player-quiz) (λ (x) (end-screen file))])))


(define BKGR (rectangle 1000 300 "solid" "navajowhite"))
(define end-screen (λ (file) (overlay (text/font (string-append "you have completed all of the questions!
\nplease refer to the file \"" file "\"
in this program's working directory to see how you did!")
                                                 25 "olivedrab" "Ewert" "system" "normal" "normal" #f)
                                      BKGR)))

; draw-quiz : QuizPlayer -> Image
; Draw the current question
(define (draw-quiz quiz-player)
  (cond [(empty? (quiz-player-quiz quiz-player)) (end-screen "default")]
        [(cons? (quiz-player-quiz quiz-player))
         (overlay (draw-question (first (quiz-player-quiz quiz-player)))
                  BKGR)]))
(check-expect (image? (draw-quiz (make-quiz-player the-quiz '()))) #t)
(check-expect (image? (draw-quiz (make-quiz-player '() '()))) #t)

; A Pair is a (make-pair String Number)
; and represents a question and its selection key
(define-struct pair [str i])
; draw-question : Question -> Image
; draws the text and options of a question
(define (draw-question question)
  (above (text (question-question question) 30 "black")
         (foldr (λ (answer-pair-chunk rest) (above (foldr (λ (answer-pair rest) (beside (question-text answer-pair) rest))
                                                          empty-image
                                                          answer-pair-chunk)
                                                rest))
                empty-image
                (break-into-threes (map make-pair (question-answers question) (build-list (length (question-answers question)) add1))))))
(check-expect (image? (draw-question lincoln)) #t)

; question-text : Pair -> Image
; the text of a question as a given string
(define (question-text pair)
  (text (string-append (pair-str pair) " (" (number->string (pair-i pair)) ")  ") 30 "red"))
(check-expect (image? (question-text (make-pair "foo" 1))) #t)

; break-into-threes : [List-of X] -> [List-of [List-of X]]
; split into lists of length 3 or less
(define (break-into-threes xlist)
  (cond [(< (length xlist) 3) (list xlist)]
        [(>= (length xlist) 3) (cons (list (first xlist) (second xlist) (third xlist))
                                     (break-into-threes (rest (rest (rest xlist)))))]))
(check-expect (break-into-threes '(1 2 3 4 5 6 7 8)) '((1 2 3) (4 5 6) (7 8)))


; enter-guess : QuizPlayer KeyEvent -> QuizPlayer
; Enter a guess for the current question, record the answer, and advance the quiz
(define (enter-guess quiz-player key)
  (cond [(number? (string->number key)) (make-quiz-player (rest (quiz-player-quiz quiz-player))
                                                          (cons (make-result (first (quiz-player-quiz quiz-player)) (string->number key))
                                                                (quiz-player-result quiz-player)))]
        [(string=? key "r") (make-quiz-player the-quiz '())]
        [else quiz-player]))
(check-expect (enter-guess (make-quiz-player the-quiz '()) "3")
              (make-quiz-player
               (list
                (make-question "What is the chemical composition of graphite?" (list "H₂O" "NaCl" "carbon allotrope" "3(O₂N₂CH₂)") 3)
                (make-question "In what language does mba'eichapa mean \"hello\"?" (list "Danish" "Guarani" "Hmong" "Igbo" "Lingala") 2)
                (make-question "When was the United States Constitution signed into law?" (list "1764" "1776" "1783" "1787") 4)
                (make-question "What is the second-best programming language?" (list "HTTP" "SFTP" "node.js" "Arduino C" "these are not programming languages") 5)
                (make-question "What was the first name of the man\n who assasinated President Abraham Lincoln?" (list "John" "Henry" "William" "Arthur" "Theodore" "Thomas") 1))
               (list (make-result (make-question "What is the best programming language?" (list "C" "Racket" "C++" "Java" "Python" "Lisp") 2) 3))))
(check-expect (enter-guess (make-quiz-player '(la la la la) '(foo foo foo foo)) "r") (make-quiz-player the-quiz '()))
(check-expect (enter-guess (make-quiz-player '(la la la la) '(foo foo foo foo)) "e") (make-quiz-player '(la la la la) '(foo foo foo foo)))

(quiz-program the-quiz "answers.txt")